/*
 * View.java
 * This class create a View object that extend JComponet, then display the album
 * saved, all the changes should be able to be seen here. But no modification on
 * album can be applied here.
 */

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.plaf.basic.BasicFileChooserUI;
import java.util.*;
import java.beans.PropertyVetoException;
import javax.imageio.*;
import java.awt.image.*;
import javax.swing.border.*;
/* Page class
 *
 * The purpose of this class is display and show of the album that in the database
 * no modification can be applied, just viewing and close.
 *
 * Written by : Turki Almadi
 *
 * Version 1.1 30 Nov 2006
 *
 * Revision    Status       Date            By:
 * 1.0         Created      25 Nov 2006    Turki Almadi
 * 1.1         Modified     26 Nov 2006    Zheng Zhang(Simon)
 * 1.2         Modified     30 Nov 2006    Turki Almadi, Howie Lee
 */
public class View extends JComponent
{
	JPanel pView = new JPanel(false);
	JPanel pCenter	= new JPanel();
	JToolBar repTool = new JToolBar();
	JButton load = new JButton("View Album");
	JButton close = new JButton("Close Album");
   //album list file
	File albumListFileR = new File("Album/albumListR.txt");
   File albumListFileW = new File("Album/tempFile.txt");
	//used when viewing with no albums in DB.
	File albumsExist = new File("Album/albumsExist.txt");

	//internal window creation
	JInternalFrame viewAlbumFrame = new JInternalFrame();
	JComboBox pageNumB = new JComboBox();
	JPanel pViewCenter = new JPanel();
	ActionHandler g = new ActionHandler();

	//variable declarations.
	int currentPageNum;
	String albumSelected;
	int pageNums;
	int textNums;
	int imageNums;
	JLabel[] textL;
	JLabel[] imageL;
	BufferedImage ImageBuffer = null;
	Image iImage = null;


	public View()
	{
		repTool.add(load);
		repTool.add(close);
		pView.setLayout(new BorderLayout());
		pView.add(repTool,BorderLayout.NORTH);
		pCenter.setPreferredSize(new Dimension(550,400));
		pView.add(pCenter,BorderLayout.CENTER);

		load.addActionListener(g);
		close.addActionListener(g);
		pageNumB.addActionListener(g);

		//internal frame addition
		pCenter.add(viewAlbumFrame);
		viewAlbumFrame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		viewAlbumFrame.add(pageNumB,BorderLayout.NORTH);
		pViewCenter.setLayout(null);
		viewAlbumFrame.add(pViewCenter,BorderLayout.CENTER);
	   viewAlbumFrame.setPreferredSize(new Dimension(800,495));



	}//a constructor
//----------------------------------------
    public JComponent ViewPanel()
    {
        return pView;
    }

	/*
	 * Class ActionHandler
	 * This method handles the basic GUI and call the viewAlbum function to get
	 * album loaded properly.
	 *
	 * precondition: the system creating the basic GUI
	 * postcondition: the basic GUI of view part is done
	 */
    //Action Listeners
	 public class ActionHandler implements ActionListener
	 {
		public void actionPerformed(ActionEvent g)
		{
			if (g.getSource() == load)
			{
				if(!albumsExist.exists()){JOptionPane.showMessageDialog(null,"There are no albums to view!");}
	         else{viewAlbum();}
			}
			else if (g.getSource() == close)
			{
			   closeAlbum();
			}
			else if (g.getSource() == pageNumB)
			{
			   currentPageNum = (Integer) pageNumB.getSelectedItem();
				updateViewFrame();
			}
		}
	 }//end Action Listeners

	/*
	 * Class viewAlbum
	 * This function let the user choose from the album list that all the saved
	 * albums and read all the information about that album, call updateViewFrame
	 * to display it.
	 *
	 * precondition:system is at the view part, no other album loaded is not closed
	 *              yet. there is at least one album stored in the system.
	 *
	 * postcondition: system is displaying the user chosen album, no modification
	 *                can be applied.
	 *
	 */
	 //when View Album is selected
	 public void viewAlbum()
	 {
	   try{
		      BufferedReader in = new BufferedReader(new FileReader(albumListFileR));
		      int counter = 0;
			   int counter2 = 0;
			   String str;
			   while((str = in.readLine()) != null){counter++;}
		      Object[] albumList = new Object[counter];
				in = new BufferedReader(new FileReader(albumListFileR));
			   while((str = in.readLine()) != null){albumList[counter2]=str; counter2++;}
				Object selected = JOptionPane.showInputDialog(null,
                       "Choose one", "Album List",JOptionPane.INFORMATION_MESSAGE, null,albumList, albumList[0]);
	         albumSelected = (String) selected;

			   pageNumB.setEnabled(false);
	         pageNumB.removeActionListener(g);
				currentPageNum = 1;
			   pageNumB.removeAllItems();
		      copyDirectory(new File("Album\\"+albumSelected),new File("Album\\temp\\"+albumSelected));
				if(new File("Album\\temp\\"+albumSelected+"\\NumOfPage.txt").exists())
		       {
			      in = new BufferedReader(new FileReader("Album\\temp\\"+albumSelected+"\\NumOfPage.txt"));
			      pageNums = Integer.parseInt(in.readLine());
			      for(int i=0; i<pageNums; i++)
			       {
				      pageNumB.addItem(i+1);
			       }
		        }
				 pageNumB.addActionListener(g);
	          if (pageNums != 0)
				 {
				 pageNumB.setEnabled(true);
				 }

				if (albumSelected != null)
				 {
					viewAlbumFrame.setTitle(albumSelected);
	            viewAlbumFrame.pack();
	            viewAlbumFrame.show();
					updateViewFrame();
             }
			}

	  catch ( IOException e){ System.out.println(e);}
	 }

	/*
	 * Class closeAlbum
	 * This function can close the album, no changes can be made.
	 */
   public void closeAlbum()
	{
	  pViewCenter.removeAll();
	  viewAlbumFrame.hide();
	  pView.updateUI();
	}

 	/*
	 * Class updateViewFrame()
	 * This function actually read from the database and display the album. it
	 * includes severl subparts, such as: display texts, display images and display
	 * the editting effect on the image
	 *
	 * preconidition: when album GUI needs to be updated
	 * postcondition: the update on GUI is done as well as the database.
	 *
	 */

 public void updateViewFrame()
  {
    pViewCenter.removeAll();

	 try{
	 //display texts.
	 if(new File("Album\\temp\\"+albumSelected+"\\page"+currentPageNum+"\\numOfText.txt").exists() && currentPageNum > 0)
		{
			BufferedReader in = new BufferedReader(new FileReader("Album\\temp\\"+albumSelected+"\\page"+currentPageNum+"\\numOfText.txt"));
	      textNums = Integer.parseInt(in.readLine());
			in.close();
			textL = new JLabel[textNums];

		  for(int i=1; i<=textNums; i++)
		   {
			  String textValue = Page.getTextValue(currentPageNum, albumSelected, i);
			  boolean isTitle = Page.getTextType(currentPageNum, albumSelected, i);
			  textL[i-1] = new JLabel();
			  textL[i-1].setText(textValue);
			  if(isTitle){
			     textL[i-1].setSize(textValue.length()*10,15);
				  textL[i-1].setFont(new Font("Arial", Font.BOLD, 14));
				           }
			  else{
			     textL[i-1].setSize(textValue.length()*9,15);
				  textL[i-1].setFont(new Font("Arial", Font.BOLD, 12));
					}
			  textL[i-1].setVisible(false);
			  pViewCenter.add(textL[i-1]);
			  textL[i-1].setLocation((int)Page.getTextPos(currentPageNum, albumSelected, i).getX()*(800/550),
			                         Page.getTextPos(currentPageNum, albumSelected, i).getY());
			  textL[i-1].setVisible(true);

			 }}


		  //display images.
		  if(new File("Album\\temp\\"+albumSelected+"\\page"+currentPageNum+"\\numOfImage.txt").exists())
		   {
			  BufferedReader in = new BufferedReader(new FileReader("Album\\temp\\"+albumSelected+"\\page"+currentPageNum+"\\numOfImage.txt"));
	        imageNums = Integer.parseInt(in.readLine());
			  in.close();
			  imageL = new JLabel[imageNums];

		  for(int i=1; i<=imageNums; i++)
		   {
			  String imageDir = Page.getImageDir(currentPageNum, albumSelected, i);
			  if (!(new File(imageDir).exists()))
			  {
			    i++;
				 if(i > imageNums){break;}
				 else{imageDir = Page.getImageDir(currentPageNum, albumSelected, i);}
			  }
			  else
			  {

			  double[] imageSize = new double[2];
			  Position[] crop = new Position[2];
			  double rotation = Page.getImageRotation(currentPageNum, albumSelected, i);
			  imageSize = Page.getImageSize(currentPageNum, albumSelected, i);
			  crop = Page.getImageCrop(currentPageNum, albumSelected, i);
			  int x1 = crop[0].getX();
			  int y1 = crop[0].getY();
			  int x2 = crop[1].getX();
			  int y2 = crop[1].getY();
			  imageL[i-1] = new JLabel();
			  double labelH = imageSize[0];
			  double labelW = imageSize[1];

			  try{
			  ImageBuffer = ImageIO.read(new File(imageDir));
			  }catch (Exception e) {}

			  double origH = y2;
			  double origW = x2;

			  iImage = ImageBuffer;
				//________________CROP_________________________
			  try
			  {
				BufferedImage bi = ImageBuffer.getSubimage(x1, y1, x2-x1, y2-y1);
				ImageBuffer = bi;
			  }
			  catch (RasterFormatException e) {}
			  //_______________END___CROP____________________

			  //_______________ROTATION_____________________
			  ImageBuffer = Tilt.tilt(ImageBuffer,rotation);
			  //____________END_______ROTATION______________
			  iImage = ImageBuffer;


			  //_______________RESIZE_________________________
			  int disH = (int) (labelH*(iImage.getHeight(null)));
			  int disW = (int) (labelW*(iImage.getWidth(null)));
			  iImage = iImage.getScaledInstance(disW, disH, Image.SCALE_FAST); //problems here.
			  //____________END___RESIZE_____________________

           imageL[i-1].setIcon(new ImageIcon(iImage));
			  imageL[i-1].setSize(disW+4,disH+4);
			  imageL[i-1].setVisible(false);
			  pViewCenter.add(imageL[i-1]);
			  imageL[i-1].setLocation(Page.getImagePos(currentPageNum, albumSelected, i).getX(),Page.getImagePos(currentPageNum, albumSelected, i).getY());
			  imageL[i-1].setVisible(true);

			  ImageBuffer.flush();
			  iImage.flush();

			 }}}




        }catch(IOException e){}

		viewAlbumFrame.pack();
	   viewAlbumFrame.show();
		viewAlbumFrame.updateUI();

  }



//-------------HELPER-----METHODS------------------
	/*
	 * Class copyDirectory
	 * This method will be useful as well in the album.java, which copy the content
	 * of one directory to an other.
	 *
	 * precondition: exist two directory
	 *
	 * postcondition : one have the same content as the other
	 */
	public void copyDirectory(File sourceLocation , File targetLocation)
    throws IOException {

        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }

            String[] children = sourceLocation.list();
            for (int i=0; i<children.length; i++) {
                copyDirectory(new File(sourceLocation, children[i]),
                        new File(targetLocation, children[i]));
            }
        } else {

            InputStream in = new FileInputStream(sourceLocation);
            OutputStream out = new FileOutputStream(targetLocation);

            // Copy the bits from instream to outstream
            byte[] buf = new byte[1024];
            int len;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
    }


//--------------END--HELPER--METHODS----------------

//----------------------------------------
}