import java.util.*;

public class SearchFunction
{
	private final int ZERO=0;
	private int count;

	public SearchFunction()
	{

	}
	//**********************************************
	//public search function
	//@param 4:
	//@return Vector<Integer>
	//NOTE: if no picture in repository, the vector.size() should return 0
	//**********************************************
	public Vector<Integer> search(int selNumber, Vector<DescriptorListNode> tempPtr,
				Vector<Integer> checkBox, Vector<String> editBox)
	{
		if(selNumber == 1)
		{
			return searchALL(tempPtr);
		}
		else if(selNumber == 2)
		{
			return searchAND(tempPtr, checkBox, editBox);
		}
		else if (selNumber == 3)
		{
			return searchOR(tempPtr, checkBox, editBox);
		}
		else
		{
			return null;
		}

	}



//**********************PRIVATE FUNCTIONS************************

	//**********************************************
	//search all images
	//@param:1 , ptr to data structure
	//@return Vector<Integer>
	//**********************************************
	private Vector<Integer> searchALL(Vector<DescriptorListNode> tempPtr)
	{
		Vector<Integer> ids = new Vector<Integer>();


		//use Data Structure to get all IDs into a vector<int>
		int i=0;
		for(; i< tempPtr.get(ZERO).getDescriptors().size();i++)
		{
			ids.add(tempPtr.get(ZERO).getDescriptors().get(i).getID());
		}

		return ids;
	}

	//**********************************************
	//search AND
	//@param 3:
	//@return Vector<Integer>
	//**********************************************
	private Vector<Integer> searchAND(Vector<DescriptorListNode> tempPtr,
						Vector<Integer> checkBox, Vector<String> editBox)
	{
		Vector<Integer> ids = new Vector<Integer>();


		if( checkBox.size() ==0)
		{
			//Show error message that checkBox must be >0
		}
		else if( checkBox.size() == 1)
		{
			for(int imageNum=0; imageNum < tempPtr.get(ZERO).getDescriptors().size(); imageNum++)
			{
				int iType=0;
				if( tempPtr.get(checkBox.get(iType)).getDescriptors().get(imageNum)
								.getValue().compareToIgnoreCase( editBox.get(iType)) ==0 )
				{
					count = imageNum;
					ids.add(count);
				}
			}
		}
		else
		{
			for(int imageNum=0; imageNum < tempPtr.get(ZERO).getDescriptors().size(); imageNum++)
			{
				int iType=0;
				if( tempPtr.get(checkBox.get(iType)).getDescriptors().get(imageNum)
								.getValue().compareToIgnoreCase( editBox.get(iType)) ==0 )
				{
					iType++;
					recurseAND( tempPtr, checkBox, editBox, iType, checkBox.size(),imageNum,ids);
				}
			}
		}

		return ids;
	}


	//**********************************************
	//**********************************************
	private Vector<Integer> searchOR(Vector<DescriptorListNode> tempPtr,
						Vector<Integer> checkBox, Vector<String> editBox)
	{
		Vector<Integer> ids = new Vector<Integer>();

		if( checkBox.size() ==0)
		{
			//Show error message that checkBox must be >0
		}
		else if( checkBox.size() == 1)
		{
			for(int imageNum=0; imageNum < tempPtr.get(ZERO).getDescriptors().size(); imageNum++)
			{
				int iType=0;
				if( tempPtr.get(checkBox.get(iType)).getDescriptors().get(imageNum)
								.getValue().compareToIgnoreCase( editBox.get(iType)) ==0 )
				{
					count = imageNum;
					ids.add(count);
				}
			}
		}
		else
		{
			for(int imageNum=0; imageNum < tempPtr.get(ZERO).getDescriptors().size(); imageNum++)
			{
				int iType=0;
				recurseOR( tempPtr, checkBox, editBox, iType, checkBox.size(),imageNum,ids);
			}
		}

		return ids;
	}








	//**********************************************
	//**********************************************
	private boolean recurseAND( Vector<DescriptorListNode> tempPtr,
							 Vector<Integer> checkBox,
							 Vector<String> editBox,
							 int iType,
							 int size,
							 int imageNum,
							 Vector<Integer> ids)
	{
		if( size-1 == iType && tempPtr.get( checkBox.get(iType) ).getDescriptors()
				.get(imageNum).getValue().compareToIgnoreCase( editBox.get(iType)) ==0)
		{
			count = imageNum;
			ids.add(count);
			return true;
		}
		else if( size-1 > iType && tempPtr.get( checkBox.get(iType) ).getDescriptors()
				.get(imageNum).getValue().compareToIgnoreCase( editBox.get(iType)) ==0)
		{
			iType++;
			recurseAND( tempPtr, checkBox, editBox, iType, checkBox.size(), imageNum,ids);
		}
		else
		{
			return false;
		}
		return false;
	}

	private boolean recurseOR( Vector<DescriptorListNode> tempPtr,
								 Vector<Integer> checkBox,
								 Vector<String> editBox,
								 int iType,
								 int size,
								 int imageNum,
							 Vector<Integer> ids)

	{

		if( size-1 >= iType && tempPtr.get( checkBox.get(iType) ).getDescriptors()
				.get(imageNum).getValue().compareToIgnoreCase( editBox.get(iType)) !=0)
		{
			iType++;
			recurseOR( tempPtr, checkBox, editBox, iType, checkBox.size(), imageNum,ids);
		}
		else if( size-1 >= iType && tempPtr.get( checkBox.get(iType) ).getDescriptors()
				.get(imageNum).getValue().compareToIgnoreCase( editBox.get(iType)) ==0)
		{

			count = imageNum;
			ids.add(count);
			return true;
		}
		else
		{
			return false;
		}
		return false;
	}
}