/*
 * Repository.java
 *
 * This Class is the main class that controls most of the functionality
 * of the Repository Tab in the DPAS program. This file only contains one class
 * named Repository.
 *
 */


//import statements
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.plaf.basic.BasicFileChooserUI;
import java.util.*;
import javax.imageio.*;

/* Repository class
 *
 * The purpose of this class is to maintiain the gui for the Repository tab
 * under the DPAS system.  It uses other class extended panels to show its
 * needed functionality and GUI.  It listens to the actions from its sub panels
 * when needed and regulates what panel is showing on its frame.
 *
 *
 * Written by : Roger Yang
 *
 *
 * Version 1.4 29 Nov 2006
 *
 * Revision    Status       Date            By:
 * 1.0         Created      2 Nov 2006     Roger Yang
 * 1.1		   Modified 	5 Nov 2006	   Roger Yang
 * 1.2		   Modified    11 Nov 2006	   Roger Yang
 * 1.3		   Modified    22 Nov 2006	   Roger Yang
 * 1.4		   Modified    29 Nov 2006	   Roger Yang
 */

public class Repository extends JComponent
{
	//Declare and initialize the Database for image name, descriptor data
	DescriptorDataStructure DescriptorData = new DescriptorDataStructure();
	//Declare and initialize the Database to store file extensions.
	RFileName FileExtension = new RFileName();

	//Declare Gui names for toolbar and buttons
	JToolBar repTool = new JToolBar();
	JButton addi = new JButton("Add Image");
	JButton deli = new JButton("Delete Image");
	JButton addd = new JButton("Add Descriptor");
	JButton edid = new JButton("Edit Descriptor Value");

	//Declare dialogs for the repository tab
	JDialog dlgEdit = new JDialog();
	JDialog dlgDelete = new JDialog();

	//Declare vector for the dynamic gui
	Vector<JTextField> tf = new Vector<JTextField>();
	//Declare vector for taking return from search panel
	Vector<Integer> SearchResult = new Vector<Integer>();

	//Declaring the Panels needed for the Repository Tab
	JPanel pRepository = new JPanel(false);

	//Initialize panels from customized panel classes
	ImagePanel pCenter	= new ImagePanel();
	SearchPanel pSearch = new SearchPanel();

	//Initializefile name variable and set it to 0 by default
	int CurrentFileName = 0;

	//Declare and initialize vector for temp storage
	private static Vector<DescriptorListNode> descriptorPtr;

	/**
     * Class Constructor
     * This function sets the default values for the gui and variables
     * when the class is first initated.
     */

	public Repository()
	{
		// Create a directory; all ancestor directories must exist
    	boolean success = (new File("Repository")).mkdir();
    	if (!success)
    	{
        	// Directory creation failed
        	// or Directory already Exists
    	}

		//add buttons to the menu
		repTool.add(addi);
		repTool.add(deli);
		repTool.add(addd);
		repTool.add(edid);
		//Set Layout for panels
		pRepository.setLayout(new BorderLayout());

		//Add title to panels

		pCenter.setBorder(new TitledBorder(""));

		//pCenter.setPreferredSize(new Dimension(550,400));

		//Add Panels to the main pRepository panel
		pRepository.add(repTool,BorderLayout.NORTH);
		pRepository.add(pSearch,BorderLayout.EAST);
		pRepository.add(pCenter,BorderLayout.CENTER);


		//Add Action handlers
		ActionHandler e = new ActionHandler();
		addi.addActionListener(e);
		deli.addActionListener(e);
		addd.addActionListener(e);
		edid.addActionListener(e);

		/**
		 *Adding Actionlistener for subpanel pSearch
		 *Also need to add in Album
		 */
		pSearch.SearchOK.addActionListener(e);



		//Construct vector
		descriptorPtr = new Vector<DescriptorListNode>();
		FileExtension.loadExt();


	}//end constructor

	// return component to show repository panel
    public JComponent RepositoryPanel()
    {
        return pRepository;
    }

	/**
     * Class Actionhandler
     * This function handles all the actions from the actionlisteners
     */
	public class ActionHandler implements ActionListener
	{
		//Actions that needs to be performed for each button
		public void actionPerformed(ActionEvent e)
		{
			//if add image to repository is selected
			if (e.getSource() == addi)
			{
				addImagetoRepository();
			}
			//if delete image option is selected
			else if (e.getSource() == deli)
			{
				//if a image is selected in pCenter panels
				if (pCenter.selected)
				{
						deleteImageFromRepository();
						pCenter.selected = false;
				}
				//if a image has not been selected
				else
				{
					//show error if no image is selected
					JOptionPane.showMessageDialog(null,
					"Select a Picture from Search First");
				}
			}
			//if add descriptor type is selected
			else if (e.getSource()  == addd)
			{
				//add new descriptor type to repository
				AddDescriptorToRespository();
				//update the search gui to show new descriptor type
				pSearch.updateSelectPanel();

			}
			//if edit descriptor value is selected
			else if (e.getSource() ==edid)
			{
				//if an image is already selected
				if (pCenter.selected)
				{
					//edit the descriptor value
					EditDescriptorValue(pCenter.selectPicture);
				}
				//if an image is not selected
				else
				{
					//ask user to selecte a image first
					JOptionPane.showMessageDialog(null,
					"Select a Picture from Search First");
				}
			}
			//if the ok button the sub panel search is clicked
			else if (e.getSource() == pSearch.SearchOK)
			{
				//invoke searchpanel's search method and get the search result
				SearchResult = pSearch.Search();
				//show the images that was returned from the search result
				pCenter.showImage(SearchResult);
				//update gui to show the images
				pCenter.updateUI();
			}
		}//end action performed
	}//end actionlistner

	/**
     * addImagetoRespository
     * This function opens a filechooser and let the user chooses the file.
     * after the file is choosed, it copies it into the repository folder and
     * create the thumbnails for the system future use.
     *
     * Precondition : repository is ready
     * Postcondition : image is Copied, thumbnails created.
     */
    public void addImagetoRepository()
    {
	  JFileChooser fc = new JFileChooser ();
      File fFile = new File ("default.jpg");
      String NextFileName = new String("0");
      String FileExt = new String("jpg");


      fc.setDialogTitle ("Select Image");

      // select only files
      fc.setFileSelectionMode ( JFileChooser.FILES_ONLY);

      // current directory
      fc.setCurrentDirectory (new File ("My Documents"));

      //make a filter
      JavaFilter filter = new JavaFilter();

      fc.setFileFilter (filter);

      //disable all file option from drop down box
      fc.setAcceptAllFileFilterUsed(false);

	 //Add the preview pane.
      fc.setAccessory(new ImagePreview(fc));

      //Some settings for the dialog box
      fc.setMultiSelectionEnabled(false);

      // Now open chooser
      int result = fc.showDialog(this,"Add");

      //check user selection
      if (result == JFileChooser.CANCEL_OPTION)
      {
         //When Cancel is Clicked
         //JOptionPane.showMessageDialog(null,
					//"Cancel Pushed");
      }
      else if (result == JFileChooser.APPROVE_OPTION)
      {
      	 //When Open is Clicked

		fFile = fc.getSelectedFile ();
		FileExt = getExtension(fFile);

		int iNextFileName =  0;
		iNextFileName = DescriptorData.createNextID();
		//get the correct filename to use from repository
		NextFileName = String.valueOf(iNextFileName);

		File dstFile = new File("Repository",NextFileName+"."+FileExt);

		try{
			copy(fFile,dstFile);
		}
		catch(IOException e)
		{
			JOptionPane.showMessageDialog(null,
					"Exception from copy caught");
			return;
    	}

    	CreateThumb ThumbCreator = new CreateThumb();
    	ThumbCreator.SaveThumb(NextFileName,FileExt);
		DescriptorData.addDescriptorValue(iNextFileName);
		FileExtension.addRFileName(FileExt);
		//System.out.println("iNextFileName is "+iNextFileName);

		//add empty descriptor value to datastructure first
		//to avoid out of range access
		for(int i=0;i < DescriptorData.size(); i++)
		{
			DescriptorData.editDescriptorValue(iNextFileName,"",DescriptorData.GetDescriptorType(i));
		}
		EditDescriptorValue(iNextFileName);

		//When Image is Added
         JOptionPane.showMessageDialog(null,
					"Image Added to Repository");

      }
	//finish
	}

	//
	/**
     * deleteImageFromRepository
     * deleting a image from the repository directory and also
	 * informs the data structure.
     *
     * Precondition : image is selected in the pCenter panel
     * Postcondition : image selected is deleted from the repository.
     */
	public void deleteImageFromRepository()
	{

	  //get selected image from the main panel
	  final Integer imageID = pCenter.selectPicture;
	  //create a temp to store image preview
	  Image imgPreview = null;

	  //get the extension of the image
	  final String FileExt = FileExtension.getFileExt(imageID);
	  //get set the file to open thumbnail
	  final File fImage = new File("Repository/"+imageID.toString()+"tmb."+FileExt);
	  //try loading the thumbnail image
	  try
	  {
		//load in thumbnail image
		imgPreview = ImageIO.read(fImage);
	  }
	  catch (Exception e) {}

	  //create a frame for popup dialog
	  Frame window = new Frame();
	  //create panels for the dialog
      JPanel pPreviewImage = new JPanel();
	  JPanel pOptions = new JPanel();

	  //set title for the dialog
      dlgDelete = new JDialog(window, "Delete Image", true);

      //set layout for the dialog
      dlgDelete.setLayout(new BorderLayout());

      // Create an OK button
	  JButton delete = new JButton ("Delete");
	  JButton cancel = new JButton("Cancel");

	  //set layout for the subpanel
	  pOptions.setLayout(new GridLayout(1,2));

	  //add the buttons to the panel
	  pOptions.add(delete);
	  pOptions.add(cancel);

	  //add thumbnail to label
	  pPreviewImage.add(new JLabel(new ImageIcon(imgPreview)));
	  //add a label to warn user
	  pPreviewImage.add(new JLabel("Delete Image from Repository (and Albums that have it)?"));
	  //set preferred size
	  pPreviewImage.setPreferredSize(new Dimension(300,400));
	  pOptions.setPreferredSize(new Dimension(400,30));

	  //add subpanel to main dialog
	  dlgDelete.add(pPreviewImage, BorderLayout.CENTER);
	  dlgDelete.add(pOptions, BorderLayout.SOUTH);

	  //add action listeners for the dialog
	  delete.addActionListener ( new ActionListener()
	  {
		public void actionPerformed( ActionEvent e )
		{
			//set file path for deleting
			final File fLargeImage = new File("Repository/"+imageID.toString()+"."+FileExt);
	 		final File fSmallThumb = new File("Repository/"+imageID.toString()+"stmb."+FileExt);
			//try to delete the images
			boolean success = (fImage.delete()&&fLargeImage.delete()&&fSmallThumb.delete());
    		if (!success)
    		{
        		//if image not deleted show error to user
        		JOptionPane.showMessageDialog(null,
					"Image Deletion Failed");
   			}
   			else
   			{
				//if image is deleted remove all image data from database
				FileExtension.deleteRFileExt(imageID);
				DescriptorData.deleteDescriptor(imageID);
				//remove search result to stop showing delete image
				SearchResult.remove(imageID);
				//refresh search result panel
				pCenter.showImage(SearchResult);
				//close dialog
				dlgDelete.dispose();
				//show user that image is deleted
				JOptionPane.showMessageDialog(null,
					"Selected Image Deleted");
			}
		}
	  });

	  //if cancel is selected
	  cancel.addActionListener ( new ActionListener()
	  {
		public void actionPerformed( ActionEvent e )
		{
			//close dialog
			dlgDelete.removeAll();
			dlgDelete.dispose();
		}
	  });

	  //set dialog preferred size
	  dlgDelete.setPreferredSize(new Dimension(400,400));
	  dlgDelete.pack();
	  //centre the dialog
	  dlgDelete.setLocationRelativeTo(null);
	  //show dialog
	  dlgDelete.setVisible(true);
	}


	//
	/**
     * AddDescriptorToRepository()
     * add a new descriptor type to the repository
     *
     * Precondition : no precondition
     * Postcondition : a new descriptor type is added to the depository
     */
	public void AddDescriptorToRespository()
    {

    	String message = "Please Enter the Name \nof the New Descriptior";

		JOptionPane pAddDescriptor = new JOptionPane();
    	String strDescriptorName = pAddDescriptor.showInputDialog(null,message,"Add New Descriptor",JOptionPane.QUESTION_MESSAGE );

		if (strDescriptorName!=null)
    	{
    		if  (strDescriptorName.compareTo("")==0)
    		{
					JOptionPane.showMessageDialog(null,
						"Descriptor Name Can Not Be Empty");
    		}
    		else if (strDescriptorName.length()>12)
    		{
    				JOptionPane.showMessageDialog(null,
						"Descriptor Name Cannot be Longer than 12 Characters");
    		}
    		else
    		{
    			boolean success = false;
    			success = DescriptorData.addDescriptorType(strDescriptorName);
    			if (success)
    			{
    				JOptionPane.showMessageDialog(null,
						"Descriptor "+strDescriptorName+" Type Added");
				}
				else
				{
					JOptionPane.showMessageDialog(null,
						"Descriptor Duplicated");
				}
    		}
    	}
    }

    //
	/**
     * EditDescriptorValue
     * Edit a image's descriptor values from the repository
     *
     * Precondition : image is selected in the pCenter panel
     * Postcondition : descriptor values of the selected image
     *					is modified.
     */
    public void EditDescriptorValue(final Integer imageID)
    {
    	int iPos = DescriptorData.GetPositionFromID(imageID);
    	tf.removeAllElements();

    	Image imgPreview = null;
    	final String FileExt = FileExtension.getFileExt(imageID);
		final File fImage = new File("Repository/"+imageID.toString()+"tmb."+FileExt);

	 	try
		{
			imgPreview = ImageIO.read(fImage);//.getScaledInstance(300, 200, Image.SCALE_FAST);
		}
		catch (Exception e) {}

		int ScrollHeight;
		Frame window = new Frame();
		JPanel pPreviewImage = new JPanel();
		JPanel pEditDescriptor = new JPanel();
		JPanel pOptions = new JPanel();

		JScrollPane pDescriptorMain = new JScrollPane();

    	dlgEdit = new JDialog(window, "Edit the Descriptor Value", true);

    	dlgEdit.setLayout(new BorderLayout());
    	pEditDescriptor.setLayout(new GridBagLayout());
    	pOptions.setLayout(new GridLayout(1,2));

    	// Create an OK button
		JButton ok = new JButton ("OK");
		JButton cancel = new JButton("Cancel");

		pOptions.add(ok);
		pOptions.add(cancel);

		ScrollHeight = 0;
		pPreviewImage.add(new JLabel(new ImageIcon(imgPreview)));
        for(int i=0;i < DescriptorData.size(); i++)
        {
            ScrollHeight += 50;
            JLabel label = new JLabel(DescriptorData.GetDescriptorType(i));
            tf.add(i,new JTextField(DescriptorData.GetVector().get(i).getDescriptors().get(iPos).getValue()));
            addComponents(label, tf.get(i), pEditDescriptor);
        }


		ok.addActionListener ( new ActionListener()
		{
			public void actionPerformed( ActionEvent e )
			{
				for(int i=0;i<tf.size();i++)
				{
					//System.out.println("tf.size "+tf.size());
					//System.out.println("action "+i);
					DescriptorData.editDescriptorValue(imageID,tf.get(i).getText()
								,DescriptorData.GetDescriptorType(i));
				}
				// Hide dialog
				dlgEdit.removeAll();
				dlgEdit.setVisible(false);
				pCenter.showImage(SearchResult);
			}
		});

		cancel.addActionListener ( new ActionListener()
	  	{
			public void actionPerformed( ActionEvent e )
			{
				dlgEdit.removeAll();
				dlgEdit.setVisible(false);
				pCenter.showImage(SearchResult);
			}
	  	});

		pEditDescriptor.setPreferredSize(new Dimension(250,ScrollHeight));
		pDescriptorMain.setPreferredSize(new Dimension(300,200));

		pDescriptorMain.getViewport().add(pEditDescriptor);
		dlgEdit.add( new Label ("Click OK to continue"));
		dlgEdit.add(pPreviewImage, BorderLayout.NORTH);
		dlgEdit.add( pOptions, BorderLayout.SOUTH );
		dlgEdit.add(pDescriptorMain,BorderLayout.CENTER);


    	// Show dialog

		dlgEdit.pack();
		dlgEdit.setLocationRelativeTo(null);
		dlgEdit.setVisible(true);

    }



	//Helper Functions Used in class============================================

	//
	/**
     * JavaFilter
     * This function lets the file chooser to filter out files through their
     * file extensions.
     *
     * Precondition : no condition
     * Postcondition : filter is returned so filechooser to set extension
     */
	public class JavaFilter extends javax.swing.filechooser.FileFilter
	{
	  public boolean accept (File f) {
	    return f.isDirectory ()
	          ||f.getName().toLowerCase().endsWith(".jpg")
	          ||f.getName().toLowerCase().endsWith(".jpeg")
	          ||f.getName().toLowerCase().endsWith(".bmp")
	          ||f.getName().toLowerCase().endsWith(".png");
	  }

	  public String getDescription () {
	    return "Image Files";
	    //return "Image Files";
	  }

	}

  		//
	/**
     * Copy
     * This function does a fast and easy copying of 1 file to another
     * location.
     *
     * Precondition : source file exists
     * Postcondition : a copy of source file is copied into the new location
     */
  	public static void copy(File src, File dst) throws IOException {
     InputStream in = new FileInputStream(src);
     OutputStream out = new FileOutputStream(dst);

     // Transfer bytes from in to out
     byte[] buf = new byte[1024];
     int len;
     while ((len = in.read(buf)) > 0)
     	{
         out.write(buf, 0, len);
     	}
     in.close();
     out.close();
  	}

	/**
     * getExtensions
     * This function takes the file path and get the extension of that file
     *
     * Precondition : File must exists
     * Postcondition : The extension of the file is returned
     */
    public static String getExtension(File f)
    {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');

        if (i > 0 &&  i < s.length() - 1)
        {
            ext = s.substring(i+1).toLowerCase();
        }
        return ext;
    }

	/**
     * addComponents
     * This function takes a label, a textfield and add it to the panel
     * of a gridbaglayout
     * Precondition : Jlabel and Jtextfield is set, and the panel is of a
     *					gridbaglayout.
     * Postcondition : the component is added and the spacing is according to
     *				   the gridbag constraints
     */
	private static void addComponents(JLabel label,JTextField tf,
                                      JPanel panel)
    {
        //create a gribbag contraint object
        GridBagConstraints gbc = new GridBagConstraints();
        //set the distance between each element
        gbc.insets = new Insets(2,2,2,2);
        //set the weight and thus the space of that the element takes
        gbc.weighty = 1.0;
        //set the width of the element
        gbc.gridwidth = gbc.RELATIVE;
        //set the weight and thus the space of that the element takes
        gbc.weightx = 0.1;
        //set contraints
        gbc.fill = gbc.NONE;
        //set alignment
        gbc.anchor = gbc.WEST;
        //add lable to panel
        panel.add(label, gbc);
        //set size of the textfield
        gbc.gridwidth = gbc.REMAINDER;
        //set contstraints
        gbc.weightx = 1.0;
        gbc.fill = gbc.HORIZONTAL;
        //set alignment
        gbc.anchor = gbc.WEST;
        //add textfield
        panel.add(tf, gbc);
    }

	//End Helper Functions======================================================


//----------------------------------------
}