/* 
 * RFileName.java
 * 
 * This Class stores the extension of each file added to repository in a 
 * Vector
 * 
 */ 

//import 
import java.util.*;
import java.io.*;
import javax.swing.*;

/* RFileName class
 * 
 * The purpose of this class is to store extension for each file and allow
 * interface to retrieve the extensions when needed by the system.
 * 
 * 
 * Written by : Roger Yang
 *                                                                          
 * 
 * Version 1.1 29 Nov 2006
 * 
 * Revision    Status       Date            By: 
 * 1.0         Created      24 Nov 2006     Roger Yang       
 * 1.1		   Modified 	29 Nov 2006	    Roger Yang                                                              
 */ 

public class RFileName
{
	//Declare and initialize DescriptorDataStructure
	DescriptorDataStructure DescriptorData = new DescriptorDataStructure();
	//Decalre static vector to store file extensions in memory
	private static Vector<String> FileExt = new Vector<String>();
	
	//declare final variable to store the file name that will store extension info
	private static final String FILENAMES ="FEXT";
	private static final String EXT = ".dat";
	
	//constructor which we don't need anything in it
	public RFileName()
	{
	}
	
	/** 
     * addRFileName
     * This function adds a extension into the vector and save the changes
     * into a file in repository
     *
     * Precondition : passed in str is not null and correct
     * Postcondition : extension is saved into file and memory
     */ 
	public void addRFileName(String Ext)
	{
		//add extension into vector
		FileExt.add(Ext);
		//save changes in vector into file
		saveFileExt();
	}
	
	/** 
     * deleteRFileExt
     * This function removes the extension stored in memory and file
     * which corresponds to the filename that is store in repository.
     *
     * Precondition : Filename given is in integer and exists in repository
     * Postcondition : Extension of perticular file is deleted and saved in file.
     */ 
	public void deleteRFileExt(int FileName)
	{
		//get the position of the extension in file from file name
		int i = DescriptorData.GetPositionFromID(FileName);
		//remove the ith position from the vector
		FileExt.removeElementAt(i);
		//save changes to file
		saveFileExt();
	}
	
	/** 
     * getFileExt
     * This function lets outside classes to get the file extension of a image by
     * passing in the imageID of the desired file, the extension will be returned.
     *
     * Precondition : the imageID passed in must be correct and exists in repository
     * Postcondition : the extension of the imageID file is returned
     */ 
	public String getFileExt(int FileName)
	{
		//get the position of the extension in file from file name
		int i = DescriptorData.GetPositionFromID(FileName);
		//return the extension
		return FileExt.get(i);
	}
	
	/** 
     * saveFileExt()
     * This function saves any changes in the memory into file in repository directory
     *
     * Precondition : repository directory must exist.
     * Postcondition : changes in memory is stored in file
     */ 
	public boolean saveFileExt()
	{
		//try to access and store file
		try
		{
			//open file
			PrintWriter pw = new PrintWriter( new FileWriter("Repository/"+ FILENAMES+EXT));

			//write each extension into each line.
			for(int i=0; i < FileExt.size(); i++)
			{
				//write each extension
				pw.println(FileExt.get(i));
			}

			//close FILNAMES.dat when done.
			pw.close();
			return true;
		}
		//if error occour during write
		catch(Exception e)
		{
			//Show error to user if this happens
			JOptionPane.showMessageDialog(null,
					"SaveFileExtension Error");
			return false;		
		}
	}
	
	/** 
     * LoadExt
     * This function loads all the extension data from file to memory when 
     * the system starts up.
     *
     * Precondition : file exists in correct format
     * Postcondition : data in file is loaded into memory
     */ 
	public void loadExt()
	{
		//Try open the file and load
		try
		{
			//declare and set default value for local variable
			int index = 0;
			String line;

			//declare and open file
			File TempFile = new File("Repository\\"+FILENAMES+EXT);
			
			//test if file exists if not create the file
			if (TempFile.exists()==false)
			{
				TempFile.createNewFile();
			}
			//open a filebuffer to read the file data
			FileReader fr = new FileReader(new File("Repository\\"+FILENAMES+EXT));
			//create a buffer reader for each line
			BufferedReader br = new BufferedReader(fr);
			//read each line from the file
			line = br.readLine();

			//continue to read each line of the file until no data is in
			while(line!=null)
			{
				//add each line into vector memory
				FileExt.add(line);
				//read the next line
				line = br.readLine();
			}
			//close bufferreader when the file is done reading
			br.close();
		}
		// if any exception occured during loading alert the user
		catch(Exception e){JOptionPane.showMessageDialog(null,
					"Load Database Error");}
	}
}