/*
 * ImageDB.java
 * This class create an image object to represent and remember the information of
 * image on the page of an album. some method to store information in database.
 */

//import statements
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.plaf.basic.BasicFileChooserUI;
import java.util.*;
import java.beans.PropertyVetoException;


/* Image class
 * 
 * The purpose of this class create and store information about an image on a page
 * of an album. each image is an object and will be a file that stored under a
 * page of an album
 *
 * Written by : Zheng Zhang(Simon)
 *                                                                          
 * 
 * Version 1.1 27 Nov 2006
 * 
 * Revision    Status       Date            By: 
 * 1.0         Created      24 Nov 2006    Zheng Zhang(Simon)
 * 1.1         Modified     26 Nov 2006    Turki Almadi
 * 1.2         Modified     27 Nov 2006    Zheng Zhang(Simon)
 */ 
 
public class ImageDB{
    
    //variable clearfication     
	private String directory;
	private Position p;
	private double sizeX;
	private double sizeY;
	private Position cropPCX;
	private Position cropPCY;
	private double rotate;
	private String imageId;
	private String albumName;
	private int pageNum;


    //constructor...remembering the position, size, position, rotate degree, etc
	public ImageDB(String directory,
					Position p,
					double sizeX,
					double sizeY,
					Position pCX,
					Position pCY,
	              	double rotate,
	              	int imageId,
	              	String albumName,
	              	int pageNum)
	{

		this.directory = directory;
		this.p = p;
		this.imageId = String.valueOf(imageId);
		this.sizeX = sizeX;
		this.sizeY = sizeY;
		this.rotate = rotate;
		this.cropPCX = pCX;
		this.cropPCY = pCY;
		this.albumName = albumName;
		this.pageNum = pageNum;

	}


	/*
	 * Class storeInfo //basic
	 * This function get the information stored to a album to the temp file which
	 * can be modified so that when album not saved it is not changed.
	 *
	 * precondition: system initalized, object imageDB created.
	 * postcondition: information stored the the right album and right page
	 */
	public void storeInfo(){

		try{

			PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName+"\\Page"+pageNum+"\\"+"Image"+imageId+".txt");  // Write data to textId.txt

            fileout.println(directory);                              // writing....
            fileout.println(p.getX());
				fileout.println(p.getY());
            fileout.println(sizeX);
				fileout.println(sizeY);
            fileout.println(rotate);
            fileout.println(cropPCX.getX());
				fileout.println(cropPCX.getY());
            fileout.println(cropPCY.getX());
				fileout.println(cropPCY.getY());

			fileout.close();	                                   // must close.

	    }catch(IOException e){

	    	System.out.println(e);
	    }
	}

	/*
	 * Class storeInfo //updating the pos
	 * Similar as above but more on updating the position .
	 *
	 * precondition: system initalized, the image is already in the database
	 * postcondition: information position updated the the right album and right page
	 */ 
	 
    public static void storeInfo(String albumName2, int currentPageNum, int imageID, Position pos){

		try{
			BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt"));

			  String firstLine = filein.readLine();    // remember everything except position
			  filein.readLine();                     
			  filein.readLine();
			  String fourthLine = filein.readLine();
			  String fifthLine = filein.readLine();
			  String sixthLine = filein.readLine();
			  String seventhLine = filein.readLine();
			  String eighthLine = filein.readLine();
			  String ninthLine = filein.readLine();
			  String tenthLine = filein.readLine();


         filein.close();

		 PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt");

			fileout.println(firstLine);
			fileout.println(pos.getX());               // update it
			fileout.println(pos.getY());
			fileout.println(fourthLine);
			fileout.println(fifthLine);
			fileout.println(sixthLine);
			fileout.println(seventhLine);
			fileout.println(eighthLine);
			fileout.println(ninthLine);
			fileout.println(tenthLine);


		 fileout.close();

	    }catch(IOException e){

	    	System.out.println(e);
	    }
	}



    /*
	 * Class storeInfo //updating the size
	 * Similar as above but more on updating the size .
	 *
	 * precondition: system initalized, the image is already in the database
	 * postcondition: information size updated the the right album and right page
	 */
    public static void storeInfo(String albumName2, int currentPageNum, int imageID, double newSizeX, double newSizeY){

		try{
			BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt"));

			  String firstLine = filein.readLine();                         //remember anything except size
			  String secondLine = filein.readLine();
			  String thirdLine = filein.readLine();
			  double oldSizeX = Double.parseDouble(filein.readLine());      
			  double oldSizeY = Double.parseDouble(filein.readLine());
			  String sixthLine = filein.readLine();
			  String seventhLine = filein.readLine();
			  String eighthLine = filein.readLine();
			  String ninthLine = filein.readLine();
			  String tenthLine = filein.readLine();


         filein.close();

		 PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt");

			fileout.println(firstLine);
			fileout.println(secondLine);                  
			fileout.println(thirdLine);
			fileout.println(oldSizeX*newSizeX);                       ///updating it
			fileout.println(oldSizeY*newSizeY);
			fileout.println(sixthLine);
			fileout.println(seventhLine);
			fileout.println(eighthLine);
			fileout.println(ninthLine);
			fileout.println(tenthLine);



		 fileout.close();

	    }catch(IOException e){

	    	System.out.println(e);
	    }
	}

	/*
	 * Class storeInfo //undoing the size change.
	 * Similar as above but more on change back the size .
	 *
	 * precondition: system initalized, the image is already in the database
	 * postcondition: information size changed back
	 */ 
    
    public static void storeInfo(String albumName2, int currentPageNum, int imageID, double newSizeX, double newSizeY, boolean undo){

		try{
			BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt"));

			  String firstLine = filein.readLine();
			  String secondLine = filein.readLine();
			  String thirdLine = filein.readLine();
			  double oldSizeX = Double.parseDouble(filein.readLine());
			  double oldSizeY = Double.parseDouble(filein.readLine());
			  String sixthLine = filein.readLine();
			  String seventhLine = filein.readLine();
			  String eighthLine = filein.readLine();
			  String ninthLine = filein.readLine();
			  String tenthLine = filein.readLine();


         filein.close();

		 PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt");

			fileout.println(firstLine);
			fileout.println(secondLine);
			fileout.println(thirdLine);
			fileout.println(newSizeX);
			fileout.println(newSizeY);
			fileout.println(sixthLine);
			fileout.println(seventhLine);
			fileout.println(eighthLine);
			fileout.println(ninthLine);
			fileout.println(tenthLine);



		 fileout.close();

	    }catch(IOException e){

	    	System.out.println(e);
	    }
	}


	/*
	 * Class storeInfo //updating the crop
	 * Similar as above but more on updating the crop .
	 *
	 * precondition: system initalized, the image is already in the database
	 * postcondition: information crop updated the the right album and right page
	 */ 
     public static void storeInfo(String albumName2, int currentPageNum, int imageID, Position pCX, Position pCY, boolean crop){

		try{
			BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt"));

			  String firstLine = filein.readLine();
			  String secondLine = filein.readLine();
			  String thirdLine = filein.readLine();
			  String fourthLine = filein.readLine();
			  String fifthLine = filein.readLine();
			  String sixthLine = filein.readLine();


         filein.close();

		 PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt");

			fileout.println(firstLine);
			fileout.println(secondLine);
			fileout.println(thirdLine);
			fileout.println(fourthLine);
			fileout.println(fifthLine);
			fileout.println(sixthLine);
			fileout.println(pCX.getX());
			fileout.println(pCX.getY());
			fileout.println(pCY.getX());
			fileout.println(pCY.getY());



		 fileout.close();

	    }catch(IOException e){

	    	System.out.println(e);
	    }
	}


  	/*
	 * Class storeInfo //updating the rotation degree
	 * Similar as above but more on updating the rotation degree .
	 *
	 * precondition: system initalized, the image is already in the database
	 * postcondition: information rotation degree updated the the right album and right page
	 */
  public static void storeInfo(String albumName2, int currentPageNum, int imageID, double rotation){

		try{
			BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt"));

			  String firstLine = filein.readLine();
			  String secondLine = filein.readLine();
			  String thirdLine = filein.readLine();
			  String fourthLine = filein.readLine();
			  String fifthLine = filein.readLine();
			  filein.readLine();
			  String seventhLine = filein.readLine();
			  String eighthLine = filein.readLine();
			  String ninthLine = filein.readLine();
			  String tenthLine = filein.readLine();




         filein.close();

		 PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Image"+imageID+".txt");

			fileout.println(firstLine);
			fileout.println(secondLine);
			fileout.println(thirdLine);
			fileout.println(fourthLine);
			fileout.println(fifthLine);
			fileout.println(rotation);
			fileout.println(seventhLine);
			fileout.println(eighthLine);
			fileout.println(ninthLine);
			fileout.println(tenthLine);




		 fileout.close();

	    }catch(IOException e){

	    	System.out.println(e);
	    }
	}


}