/*
 * GUI.java
 *
 * This Class is the main class that controls the interface of whole program.
 * it separate the classes to different panels
 *
 */

import javax.swing.*;
import java.awt.*;
import java.util.*;
import javax.swing.event.*;

/* Repository class
 *
 * The purpose of this class is to separate the GUI into different tabbedpanes
 *
 *
 * Written by : Howie Lee
 *
 *
 * Version 1.1 29 Nov 2006
 *
 * Revision    Status       Date            By:
 * 1.0         Created      2 Nov 2006     Howie Lee
 * 1.1		   Modified 	25 Nov 2006	   Howie Lee
 */


public class GUI extends JPanel {
	public GUI() {

        JTabbedPane tabbedPane = new JTabbedPane();

        ImageIcon icon1 = createImageIcon("img/load.gif");
        ImageIcon icon2 = createImageIcon("img/save.gif");
        ImageIcon icon3 = createImageIcon("img/subscribe.gif");

		Repository repoPanel = new Repository();
        JComponent panel1 = repoPanel.RepositoryPanel();
        tabbedPane.addTab("Repository", icon1, panel1,
                          "Image Repository");

		final Album alPanel = new Album();
        JComponent panel2 = alPanel.AlbumPanel();
        tabbedPane.addTab("Album", icon2, panel2,
                          "Edit Album");

		View vPanel = new View();
        JComponent panel3 = vPanel.ViewPanel();
        tabbedPane.addTab("View", icon3, panel3,
                          "View Album");

        tabbedPane.addChangeListener(new ChangeListener(){
            public void stateChanged(ChangeEvent evt)
            {
            	JTabbedPane pane = (JTabbedPane)evt.getSource();

            	// Get current tab
            	int sel = pane.getSelectedIndex();

           		if (sel==1)
            	{
            		alPanel.UpdateSearchUI();
           		}
			}
        });


        add(tabbedPane);
	}



    protected static ImageIcon createImageIcon(String path) {
        java.net.URL imgURL = GUI.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        } else {
            System.err.println("Couldn't find file: " + path);
            return null;
        }
    }

    /*public static void main(String[] args) {
        createAndShowGUI();
    }*/
}