/*
 * CreateThumb.java
 *
 * This Class create the thumbnails needed for the system, since original images
 * get loads into the memory, we need to force the garbage collector. so we load
 * images when we need it and create thumbnails for other function of the system.
 * After the class is disposed, the iamges store in memory also garbage collected.
 *
 */

//import statements
import java.awt.*;
import java.io.*;
import java.util.*;
import javax.imageio.*;
import java.awt.image.BufferedImage;

/* CreateThumb class
 *
 * The purpose of this class create thumbnails for each images added to the
 * repository.  2 thumbnails are created, 1 medium thumbnail and 1 small thumnail.
 *
 *
 * Written by : Roger Yang
 *
 *
 * Version 1.1 29 Nov 2006
 *
 * Revision    Status       Date            By:
 * 1.0         Created      24 Nov 2006    Roger Yang
 * 1.1		   Modified 	25 Nov 2006	   Roger Yang
 */
public class CreateThumb
{
	//class constructior , no need to initialize anything here
	public CreateThumb()
	{
		//nothing
	}

	/**
     * SaveThumb
     *
     * This function gets the filename for the original sized image, and also
     * the extension of the file. then create thumbnails and stores in the same
     * directory.
     *
     * Precondition : file name must be corrected formatted image
     * Postcondition : thumbnails created and saved
     */
	public void SaveThumb(String FileName, String FileExt)
	{
		//declare a local file and stores the file path
		File fImage = new File("Repository",FileName+"."+FileExt);
		//declare local image variable to store image files
		Image iImage = null;
		Image iImage2 = null;
		//declare local image buffer to resize image
		BufferedImage ImageBuffer;

		//declare local variable for the calculation of new image size
		int mWidth = 0;		//for medium size thumbnail width
		int mHeight = 0;	//for medium size thumbnail height
		int sWidth = 0;		//for small size thumbnail width
		int sHeight = 0;	//for small size thumbnail height

		//temp variable for calcuation so no rounding off happens during
		Float Width;
		Float Height;
		Float Ratio;
		Float Temp;

		//try to store the image and create thumbnail
		try{
			//store the image into the image buffer
			ImageBuffer = ImageIO.read(fImage);
			//get the width of the original image
			Width = new Float(ImageBuffer.getWidth());
			//get the height of the original image
			Height = new Float(ImageBuffer.getHeight());

			//if the width of the original image is larger then height
			if (Width>=Height)
			{
				//calculate the ratio of the image
				Ratio = new Float(Width/Height);
				//set the width of the medium thumbnail
				mWidth = 300;
				//initalize the temp variable to 300 to calculate
				Temp = new Float(300);
				//calculate the height in float
				Temp = new Float(Temp/Ratio);
				//store the height by rounding to int
				mHeight = Temp.intValue();

				//set the width of the small thumbnail
				sWidth = 100;
				//set default value of the temp
				Temp = new Float(100);
				//caculate the float value of the width
				Temp = (Temp/Ratio);
				//store the height of the small thumbnail
				sHeight = Temp.intValue();
			}
			//if height is larger then width
			else
			{
				//calculate the ratio
				Ratio = new Float(Height/Width);
				//set the height to default value
				mHeight = 225;
				//use temp to calcualte the float value of width
				Temp = new Float(225);
				Temp = new Float(Temp/Ratio);
				//round the width to integer
				mWidth = Temp.intValue();

				//set the height to default value
				sHeight = 100;
				//use temp to calcualte the float value of width
				Temp = new Float(100);
				Temp = (Temp/Ratio);
				//round the width to integer
				sWidth = Temp.intValue();
			}

			//get the actual image from original image with calculated size
			iImage = ImageBuffer.getScaledInstance(mWidth, mHeight, Image.SCALE_FAST);
			iImage2 = ImageBuffer.getScaledInstance(sWidth, sHeight, Image.SCALE_FAST);
			} catch (Exception e)
			{
				//show debug output to console
				System.out.println("Thumbnail creation Error!!");
			}
		//save the thumbnails to the repository directory
		saveImage(iImage, FileName+"tmb", FileExt);
		saveImage(iImage2, FileName+"stmb", FileExt);
	}

	/**
     * SaveImage
     *
     * This function takes a image and a file path and save the image via
     * a buffer to file with the correct extension.
     *
     * Precondition : file name must be corrected and formatted image correct also.
     * Postcondition : image saved to correct file path and extension.
     */
	private static void saveImage(Image image, String FileName, String FileExt)
    {
        //declare and initialize width and height from image
        int w = image.getWidth(null);
        int h = image.getHeight(null);

        //create a image buffer for drawing
        BufferedImage bi = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        //create a 2d pane for drawing
        Graphics2D g2 = bi.createGraphics();
        //draw the image from the 2d pane to the image
        g2.drawImage(image, 0, 0, null);
        //dispose the 2d pane
        g2.dispose();
        try
        {
            //write the image into the correct file location
            ImageIO.write(bi, FileExt, new File("Repository",FileName+"."+FileExt));
        }
        catch(IOException e)
        {
            //output debug info on console if error occurs
            System.out.println("write: " + e.getMessage());
        }
    }

}